﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ import Namespace="Soneta.Business.Db.Wizard" %>
<%@ import Namespace="System.Collections.Generic" %>

<script runat="server">
    
    public class PrnInfo : ContextBase {
        public PrnInfo(Context context) : base(context) {
        }

        bool daneOsobowe = true;
        [Caption("Dane pracownika")]
        [Priority(10)]
        public bool DaneOsobowe {
            get { return daneOsobowe; }
            set {
                daneOsobowe = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnInfo info;
    [Context]
    public PrnInfo Info {
        set { info = value; }
    }

    class HistoriaZatrudnieniaComparer : IComparer {
        public int Compare(object px, object py) {
            HistoriaZatrudnieniaBase x = (HistoriaZatrudnieniaBase)px;
            HistoriaZatrudnieniaBase y = (HistoriaZatrudnieniaBase)py;
            return y.Okres.CompareTo(x.Okres);
        }
    }

    void dc_ContextLoading(Object sender, EventArgs e) {
        if (dc.Context.Contains(typeof(PrnInfo)) && dc.Context.Contains(typeof(WizardUI)))
            Dokument.Visible = false;
    }

    void dc_ContextLoad(Object sender, EventArgs e) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        int lp;
        
        if (info.DaneOsobowe) {
            Datalabel1.EditValue = ph.Imie;
            if (ph.ImieDrugie.Length > 0)
                Datalabel1.EditValue += " " + ph.ImieDrugie;
			Datalabel1.EditValue += " " + ph.Nazwisko;
            Datalabel2.EditValue = ph.NazwiskoRodowe;
            Datalabel3.EditValue = ph.ImieOjca;
            if ((ph.ImieOjca.Length > 0) && (ph.ImieMatki.Length > 0))
				Datalabel3.EditValue += ", ";
			Datalabel3.EditValue += ph.ImieMatki;
            Datalabel5.EditValue = ph.Urodzony.Data + " " + ph.Urodzony.Miejsce;
            Datalabel6.EditValue = ph.Obywatelstwo.Nazwa;
            Datalabel7.EditValue = ph.PESEL;

            Datalabel9.EditValue = "";
            if (!ph.AdresZamieszkania.IsEmpty()) {
                Datalabel9.EditValue = ph.AdresZamieszkania.Linia1 + ", " + ph.AdresZamieszkania.Linia2;
            }
            else {
                Datalabel9.EditValue = ph.AdresZameldowania.Linia1 + ", " + ph.AdresZameldowania.Linia2;
            }

            Datalabel10.EditValue = "";
            Datalabel10.EditValue = ph.AdresDoKorespondencji.Linia1 + ", " + ph.AdresDoKorespondencji.Linia2;

            Datalabel11.EditValue = "";
			if (ph.Kontakt.TelefonKomorkowy.Length > 0)
                Datalabel11.EditValue += "tel.kom.: " + ph.Kontakt.TelefonKomorkowy;
            if (ph.Kontakt.SkrytkaPocztowa.Length > 0) {
                if (Datalabel11.EditValue.ToString() != "")
                    Datalabel11.EditValue += ", ";
                Datalabel11.EditValue += "skrytka pocztowa: " + ph.Kontakt.SkrytkaPocztowa;
            }
            if (ph.Kontakt.EMAIL.Length > 0) {
                if (Datalabel11.EditValue.ToString() != "")
                    Datalabel11.EditValue += ", ";
                Datalabel11.EditValue += "e-mail: " + ph.Kontakt.EMAIL;
            }
            Datalabel16.EditValue = ph.Wyksztalcenie.Kod;
            Datalabel17.EditValue = ph.Wyksztalcenie.StopienNaukowy;
            Datalabel18.EditValue = ph.Wyksztalcenie.TytulNaukowy;
            lp = 1;
            Datalabel40.EditValue = "";
            ArrayList lista = new ArrayList(ph.Pracownik.HistoriaZatrudnienia.ToArray<HistoriaZatrudnieniaBase>());
            lista.Sort(new HistoriaZatrudnieniaComparer());
            foreach (HistoriaZatrudnieniaBase hzb in lista) {
                if (hzb.Typ == TypHistoriiZatrudnienia.Zatrudnienie)
                    continue;
                UkonczonaSzkola usz = (UkonczonaSzkola)hzb;
                if (usz == null)
                    continue;
                Datalabel40.EditValue += "<tr>";
                Datalabel40.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + (usz.Nazwa.Length > 0 ? usz.Nazwa : "&nbsp;") + "</td>";
                Datalabel40.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + (usz.Okres.To.ToString().Length > 0 ? usz.Okres.To.ToString() : "&nbsp;") + "</td>";
                Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + (usz.Zawod.Length > 0 ? usz.Zawod : "&nbsp;") + "</td>";
                Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">" + (usz.Specjalnosc.Length > 0 ? usz.Specjalnosc : "&nbsp;") + "</td>";
                Datalabel40.EditValue += "</tr>";
                lp++;
            }
            if (lp == 1)
                for (lp = 1; lp < 9; lp++) {
                    Datalabel40.EditValue += "<tr>";
                    Datalabel40.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel40.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel40.EditValue += "</tr>";
                }
            Datalabel20.EditValue = "";
            Datalabel21.EditValue = "";
            foreach (UkończoneSzkolenie us in ph.Pracownik.UkończoneSzkolenia) {
                if (Datalabel21.EditValue.ToString() != "")
                    Datalabel21.EditValue += "<br>";
                Datalabel21.EditValue += "&nbsp;- " + us.Nazwa + " - " + us.Okres;
            }
            Datalabel22.EditValue = "";
            lp = 1;
            Datalabel41.EditValue = "";
            foreach (HistoriaZatrudnieniaBase hzb in lista) {
                if (hzb.Typ == TypHistoriiZatrudnienia.Wyksztalcenie)
                    continue;
                HistoriaZatrudnienia hz = (HistoriaZatrudnienia)hzb;
                if (hz == null)
                    continue;
                Datalabel41.EditValue += "<tr>";
                Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + (hz.Okres.From.ToString().Length > 0 ? hz.Okres.From.ToString() : "&nbsp;") + "</td>";
                Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + (hz.Okres.To.ToString().Length > 0 ? hz.Okres.To.ToString() : "&nbsp;") + "</td>";
                Datalabel41.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">" + ((hz.Nazwa.Length > 0 || hz.Adres1.Length > 0) ? hz.Nazwa + " " + hz.Adres1 : "&nbsp;") + "</td>";
                Datalabel41.EditValue += "<td width=\"20%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">" + (hz.Stanowisko.Length > 0 ? hz.Stanowisko : "&nbsp;") + "</td>";
                Datalabel41.EditValue += "</tr>";
				lp++;
			}
			if (lp == 1)
				for (lp = 1; lp < 9; lp++) {
                    Datalabel41.EditValue += "<tr>";
                    Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel41.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel41.EditValue += "<td width=\"20%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                    Datalabel41.EditValue += "</tr>";
                }
            Datalabel23.EditValue = "";
            SubTable upst = ph.Pracownik.Uprawnienia;
            foreach (UprawnieniePracownika up in upst) {
                if (Datalabel23.EditValue.ToString() != "")
                    Datalabel23.EditValue += "<br>";
                Datalabel23.EditValue += "&nbsp; - " + up.Definicja.Nazwa + " - " + up.Okres.ToString();
            }
            Datalabel24.EditValue = "";
            foreach (ZnajomośćJęzykaObcego zj in ph.Pracownik.JęzykiObce) {
                if (Datalabel24.EditValue.ToString() != "")
                    Datalabel24.EditValue += "<br>";
                Datalabel24.EditValue += "&nbsp; - " + zj.Jezyk.Nazwa + " - mowa: " + zj.Mowa.Nazwa + " - pismo: " + zj.Pismo.Nazwa;
            }
            Datalabel25.EditValue = "";
            Datalabel33.EditValue = ph.Powiadomic.Osoba;
            if ((Datalabel33.EditValue.ToString() != "") && (ph.Powiadomic.Adres.Length > 0))
                Datalabel33.EditValue += ", ";
            Datalabel33.EditValue += ph.Powiadomic.Adres;
            if ((Datalabel33.EditValue.ToString() != "") && (ph.Powiadomic.Telefon.Length > 0))
                Datalabel33.EditValue += ", ";
            if (ph.Powiadomic.Telefon.Length > 0)
                Datalabel33.EditValue += "telefon: " + ph.Powiadomic.Telefon;
			Datalabel39.EditValue = "";
            Datalabel34.EditValue = ph.Dokument.SeriaNumer;
            Datalabel35.EditValue = ph.Dokument.WydanyPrzez;
            Datalabel36.EditValue = "";
        } else {
            Datalabel1.EditValue = ".............................................................";
            Datalabel2.EditValue = "....................................................................";
            Datalabel3.EditValue = ".....................................................................";
            Datalabel5.EditValue = "";
            Datalabel6.EditValue = "";
            Datalabel7.EditValue = "|_|_|_|_|_|_|_|_|_|_|_|";
            Datalabel9.EditValue = "....................................................................................................................";
            Datalabel10.EditValue = "..............................................................................................................";
            Datalabel11.EditValue = "......................................................................................................................................";
            Datalabel16.EditValue = "";
            Datalabel17.EditValue = "";
            Datalabel18.EditValue = "";
            Datalabel40.EditValue = "";
            for (lp = 1; lp < 9; lp++) {
                Datalabel40.EditValue += "<tr>";
                Datalabel40.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel40.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel40.EditValue += "<td width=\"25%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel40.EditValue += "</tr>";
            }
            Datalabel20.EditValue = "";
            Datalabel21.EditValue = "";
            Datalabel22.EditValue = "";
            Datalabel41.EditValue = "";
            for (lp = 1; lp < 9; lp++) {
                Datalabel41.EditValue += "<tr>";
                Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel41.EditValue += "<td width=\"15%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel41.EditValue += "<td valign=\"top\" align=\"left\" style=\"border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel41.EditValue += "<td width=\"20%\" valign=\"top\" align=\"left\" style=\"border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;\">&nbsp;</td>";
                Datalabel41.EditValue += "</tr>";
            }
            Datalabel23.EditValue = "";
            Datalabel24.EditValue = "";
            Datalabel25.EditValue = "";
			Datalabel33.EditValue = ".............................................................................";
            Datalabel39.EditValue = "........................................................................................................................................................";
            Datalabel34.EditValue = "....................................";
            Datalabel35.EditValue = "....................................";
            Datalabel36.EditValue = "....................................";
        }
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Kwestionariusz osobowy</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
<body>
    <form id="KwestionariuszOsobowy" method="post" runat="server">
        <EA:DATACONTEXT id="dc" runat="server" OnContextLoading="dc_ContextLoading" OnContextLoad="dc_ContextLoad" TypeName="Soneta.KadryPlace"></EA:DATACONTEXT>
        <ea:Section runat="server" SectionType="Header"></ea:Section>
        <ea:Section ID="Dokument" SectionType="Body" runat="server">

		<font face="Tahoma" size="2">
	
			<table cellSpacing="0" width="100%" style="border-width: 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="30%"></td>
					<td width="70%" valign="top" align="center" style="border-width: 0px 0px 1px 1px; border-style: solid; border-color: silver;">
						<br><font size="3"><b>KWESTIONARIUSZ OSOBOWY</b></font><br><br>
					</td>
				</tr>
				<tr>
					<td width="30%"></td>
					<td width="70%" valign="top" align="left" style="border-width: 0px 0px 0px 1px; border-style: solid; border-color: silver;">
						<br>1. Imię (imiona) i nazwisko:&nbsp;
						<ea:datalabel id="Datalabel1" runat="server"></ea:datalabel><br>
						<br>&nbsp;&nbsp;&nbsp;&nbsp;a) nazwisko rodowe&nbsp;
						<ea:datalabel id="Datalabel2" runat="server"></ea:datalabel><br>
						<br>&nbsp;&nbsp;&nbsp;&nbsp;b) imiona rodziców&nbsp;
						<ea:datalabel id="Datalabel3" runat="server"></ea:datalabel><br>
						<br>
					</td>
				</tr>
			</tbody>
			</table>
			
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="60%" valign="top" align="left" style="border-width: 0px 1px 0px 0px; border-style: solid; border-color: silver;">
						<br>2. Data i miejsce urodzenia
						<ea:datalabel id="Datalabel5" runat="server"></ea:datalabel><br><br>
					</td>
					<td width="40%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>3. Obywatelstwo
						<ea:datalabel id="Datalabel6" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>
			
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="46%" valign="top" align="left" style="border-width: 0px 1px 0px 0px; border-style: solid; border-color: silver;">
						<br>4. Numer ewidencyjny (PESEL)&nbsp;
						<ea:datalabel id="Datalabel7" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>

			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>5. Dane kontaktowe<br><br>
					</td>
				</tr>			
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>&nbsp;&nbsp;a) Adres zameldowania
						&nbsp;<ea:datalabel id="Datalabel9" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>&nbsp;&nbsp;b) Adres do korespondencji
						&nbsp;<ea:datalabel id="Datalabel10" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>&nbsp;&nbsp;c) Kontakt
						&nbsp;<ea:datalabel id="Datalabel11" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>

			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="33%" valign="top" align="left">
						<br>6. Wykształcenie<br>
					</td>
                    <td width="33%"></td>
                    <td width="34%"></td>
				</tr>
				<tr>
					<td width="33%" valign="top" align="center">
						<br>Kod wykształcenia
						<ea:datalabel id="Datalabel16" runat="server"></ea:datalabel><br><br>
					</td>
					<td width="33%" valign="top" align="center">
						<br>Stopień naukowy
						<ea:datalabel id="Datalabel17" runat="server"></ea:datalabel><br><br>
					</td>
					<td width="34%" valign="top" align="center">
						<br>Tytuł naukowy
						<ea:datalabel id="Datalabel18" runat="server"></ea:datalabel><br><br>
					</td>
                </tr>
			</tbody>
			</table>
			<table cellSpacing="0" cellPadding="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
                    <td valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Nazwa szkoły</b></td>
                    <td width="15%" valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Rok ukończenia</b></td>
                    <td width="25%" valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Zawód</b></td>
                    <td width="25%" valign="top" align="left" style="border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;"><b>Specjalność</b></td>
                </tr>
                <ea:datalabel id="Datalabel40" runat="server"></ea:datalabel>
            </tbody>
            </table>
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="100%" valign="top" align="left">
						<br>7. Wykształcenie uzupełniające (podać datę ukończenia lub rozpoczęcia nauki w przypadku jej trwania)<br>
						&nbsp;<ea:datalabel id="Datalabel20" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="50%" valign="top" align="left" style="border-width: 0px 1px 0px 0px; border-style: solid; border-color: silver;">
						<br>a) Kursy<br>
						<ea:datalabel id="Datalabel21" runat="server"></ea:datalabel><br><br>
					</td>
					<td width="50%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>b) Studia podyplomowe<br>
						<ea:datalabel id="Datalabel22" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>

            <ea:PageBreak ID="PageBreak1" runat="server" Required="false"></ea:PageBreak>
                        <ea:PageBreak ID="PageBreak2" runat="server" Required="false"></ea:PageBreak>

			<table cellSpacing="0" width="100%" style="border-width: 1px 1px 0px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="100%" valign="top" align="left">
						<br>8. Przebieg dotychczasowego zatrudnienia<br><br>
					</td>
				</tr>
			</tbody>
			</table>

			<table cellSpacing="0" cellPadding="0" width="100%" style="border-width: 1px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
                    <td width="15%" valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Okres od</b></td>
                    <td width="15%" valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Okres do</b></td>
                    <td valign="top" align="left" style="border-width: 0px 1px 1px 0px; border-style: solid; border-color: silver;"><b>Nazwa i adres pracodawcy</b></td>
                    <td width="20%" valign="top" align="left" style="border-width: 0px 0px 1px 0px; border-style: solid; border-color: silver;"><b>Stanowisko</b></td>
                </tr>
                <ea:datalabel id="Datalabel41" runat="server"></ea:datalabel>
            </tbody>
            </table>
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>9. Dodatkowe uprawnienia, umiejętności i zainteresowania<br>
						<ea:datalabel id="Datalabel23" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>a) Znajomość języków obcych (słaba, biegła, w mowie, w piśmie)<br>
						<ea:datalabel id="Datalabel24" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>b) Prawo jazdy, obsługa komputera, inne umiejętności<br>
						&nbsp;<ea:datalabel id="Datalabel25" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>10. Osoba, którą należy zawiadomić w razie wypadku
						<ea:datalabel id="Datalabel33" runat="server"></ea:datalabel><br>
					</td>
				</tr>
				<tr>
					<td valign="top" align="center" style="font-size: 8pt;">(imię i nazwisko, adres, telefon)
					</td>
				</tr>
				<tr>
					<td valign="top" align="left">
						&nbsp;<ea:datalabel id="Datalabel39" runat="server"></ea:datalabel><br>
					</td>
				</tr>
			</tbody>
			</table>
			<table cellSpacing="0" width="100%" style="border-width: 0px 1px 1px 1px; border-style: solid; border-color: silver; font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="100%" valign="top" align="left" style="border-width: 1px 0px 0px 0px; border-style: solid; border-color: silver;">
						<br>11. Oświadczam, że dane zawarte w pkt. 1, 2, 4 i 6 są zgodne z dowodem osobistym seria i nr
						&nbsp;<ea:datalabel id="Datalabel34" runat="server"></ea:datalabel>
						&nbsp;wydanym przez&nbsp;
						<ea:datalabel id="Datalabel35" runat="server"></ea:datalabel>
						&nbsp;albo innym dowodem tożsamości&nbsp;
						<ea:datalabel id="Datalabel36" runat="server"></ea:datalabel><br><br>
					</td>
				</tr>
			</tbody>
			</table>			
			<table cellSpacing="0" width="100%" style="font-size: 10pt; font-family: tahoma; text-align:justify;">
			<tbody>
				<tr>
					<td width="50%">
						<br><br><br><br>
						<p align="center">....................................<br>
							<font size="1">(miejscowość, data)</font><br>
						</p>
					</td>
					<td width="50%">
						<br><br><br><br>
						<p align="center">....................................<br>
							<font size="1">(podpis osoby składającej kwestionariusz)</font><br>
						</p>
					</td>
				</tr>
			</tbody>
			</table>
    	</font>
        </ea:Section>
        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
    </form>
</body>
</html>
